// MK40 & MK64 RAM WRITE V2.00


#include "conio.h"
#include "iostream.h"
#include "dos.h"
#include "string.h"
#include "MK_IO200.cpp"

char revision[8]="V2.00a";
int getvalue(char* pNumber,int maxdigits);


int main(int argc,char* argv[]);
int main(int argc,char* argv[])
{
	int cval;

	if (argc<3) {	cout<<"\nSyntax error - "
				<< "\nWrite RAM program\n"
				<< "\nSyntax is WRITERAM a1 d1 a2 d2\n"
				<< "Where a1..an are addresses and\n"
				<< "and d1..dn are data values to be written\n";
				return 16; //abort program
			  }


	set_io_parameters(argc,argv);
	if (verbose) cout<<"\nWRITERAM program revision "<<revision;
	if (verbose) cout<<"\nMKIO program revision "<<IOrevision;
	if (verbose) cout<<"\nACK time limit is "<<ack_time_limit<<"0 mS";

	int loop,address,data;

	for(loop=1;loop<argc;loop+=2)
	  {	//cout << "\nAddress ="<< argv[loop];
		while(argv[loop][0]=='-') loop++;
		if (loop>=argc) break;
		address=getvalue(argv[loop],3);
		//cout << "\nData    ="<< argv[loop+1];
		data=getvalue(argv[loop+1],3);
		if ((address<0)||(address>511))
			{	cout <<"\nAddress error";return 16;}
		if ((data<0)||(data>255))
			{	cout <<"\nData error";return 16;}
		cout << "\nWriting "<<data<<" to location "<<address;
		if (address>256) write_high_ram(address-256,data);
		else		       write_ram(address,data);
	  }

	return 0;
}

int getvalue(char* pNumber,int maxdigits)
{    int multiplier,total=0;
	int numdigits=strlen(pNumber);
	if (numdigits>maxdigits)
		{	cout << "\nToo many digits";
			return -1;
		}

	if (numdigits==1) multiplier=1;
	if (numdigits==2) multiplier=10;
	if (numdigits==3) multiplier=100;


	for(int i=0;i<numdigits;i++)
	  {	total+=multiplier* (pNumber[i]-48);
		multiplier=multiplier/10;
	  }

	return total;

}
