// Control Panel READID V2.00
// NOTE: line number are hardware ordered until just before they
//	    are put on screen.


#include "string.h"
#include "iostream.h"
#include "conio.h"
#include "dos.h"
#include "mk_io200.cpp"

//Declare gobal varibles
char revision[8]="V2.00";
int G_total;		//ID running total
int G_value[65];	//Bit values for every input



int ascii2dec(int text);
int get_static();
void eight_bit(int bits,int number);

int get_static()
{    int time_limit=50,number=0;
	int bits,key,error=0;

	if(kbhit()) getch();

	write_port(0xa4);	//request a joy buffer dump
	do	{	key=getkey(time_limit);
			if (key<1) {error++;break;}
		}
	while ( (key|0x20) !='z');

	do	{	key=getkey(time_limit);
			if (key<1) {error++;break;}
			if ( (key|0x20) == 'z') break;
			bits=16*ascii2dec(key);
			//get lower nybble
			key=getkey(time_limit);
			if (key<1) {error++;break;}
			if ( (key|0x20) == 'z') break;
			bits+=ascii2dec(key);
			eight_bit(bits,number);
			number+=8;
		}
	while (1);
	if (error) return -1;
	return number;
}

void eight_bit(int bits,int number)
{         number+=7;
	for(int i=0;i<8;i++)
	{	if ((bits&1)==0) G_total+=G_value[number];
		bits=bits/2;
		number--;
	}
}

int ascii2dec(int text)
{	//disallow bad characters
	if(text<'0') return -1;
	if ((text>'9')&&(text<'A')) return -1;
	if ((text>'F')&&(text<'a')) return -1;
	if (text>'f') return -1;

	text=text|32;	//convert to lower case
	text-=48;	//convert '0-9' to 0-9
	if (text>9) text-=39;	//convert 'a-f' to 10-15
	return text;
}



int main(int argc,char* argv[]);
int main(int argc,char* argv[])
{



	int error=0,input,oldtotal,temp,bitcount=0,stable=0;
	int i,j;
	char cval;
	char datalow;
	char datahigh;
	int line;

	//zero out array
	for (i=0;i<64;i++) G_value[i]=0;


	//check command line for inputs to read
	if (argc<2) {	cout<<"\nSyntax error - to read ID on inputs 5 and 39"
				<< ", use READID 5 39\n";
				return 16; //abort program
			  }

	set_io_parameters(argc,argv);
	if (verbose) cout<<"\nREADID program revision "<<revision;
	if (verbose) cout<<"\nMKIO program revision "<<IOrevision;
	if (verbose) cout<<"\nACK time limit is "<<ack_time_limit<<"0 mS";

//main loop that reads and handles arguments passes to program
	for (i=1;i<argc;i++)
	{    input=0;error=0;temp=0;
		if (argv[i][0]=='-')
		{	if ((32|argv[i][1])=='w') stable++;
		}
		else
		{    bitcount++;
			if (bitcount>4)
				{cout<<"\nSyntax error - too many inputs selected\n";
				 return 16; //abort program
				}
			switch(strlen(&argv[i][0]))
			{	case 0:
					error++;break;
				case 2:
					input=10*ascii2dec(argv[i][temp]);
					temp++;
					if ((input<0)||(input>90)) error++;
				case 1:
					temp=ascii2dec(argv[i][temp]);
					if ((temp<0)||(temp>9)) error++;
					input+=temp;
					break;
				default:
					error++;
			}//end switch

			if (input>63) error++;
			if (error) {cout << "\nSyntax error - inputs must be 0 to 63\n";
					  return 16;}

		// Correct MK64 wiring quirk
		if (input>39)
			{	if (input&1) input--;
				else input++;
			}

		//set the bit after increasing weight of previously set values.
			for(j=0;j<64;j++) G_value[j]*=2;
			G_value[input]++;

	    }//end else
	}//end for


//	read MK inputs and calculate ID


comout_disable();

	G_total=333;
	oldtotal=666;	//just a number
	while(oldtotal!=G_total)
	{    oldtotal=G_total;
		G_total=0;
//		cout <<"x";
		input=get_static();	//read inputs and set G_total (return max inputs)
		//check for obvious errors
		if ( (input!=40) && (input!=64) )
			{	cout << "Initialization ERROR:"<< input;return 16;
			}
		if(!stable) break; //No need to match readings, just a sample
		if (oldtotal!=G_total) wait(25); //wait to read again
	}//end while

comout_enable();

	if(verbose) cout <<"\nID read was "<<G_total;
	return G_total;
}

