//KEYMAP test V2.00c 4/28/2003
//added new opcodes and key defs
//added input upto 95
//
//KEYMAP test V1.22 1/28/2002
//fixed lock up on files with out a CR at end
//
//KEYMAP test V1.20 10/22/2001
//add check for key ACK using bios memory bit
//will add auto model/rev check and epprom dump to save uneeded eprom write attempts
//disabled above check (2 places), it is usually longer that way.

char revision[8]="V2.00c";

//unsigned long int Wait_more4ready=0;	//forces wait 4 ready sub to wait a fixed time
int No_disable=0; //TRUE skips comout disable

#include "conio.h"
#include "dos.h"
#include "string.h"
#include "fstream.h"
#include "keys200.cpp"
#include "mk_io200.cpp"

char databuffer[96][20];
//added v2.00
int Gskip=0,Gnoswap=0,Gtypematic=0,Gbank=0;
int Gfast=0;
//end add

int write_eeprom(char address,char* data);
int process_line(char* line,int linenum);
void print_results();
void clearline (char* line,int bytes);
char* lookupcode (char* text);


void clearline (char* line,int bytes)
{	for (int i=0;i<bytes;i++)
	{	line[i]=0;	};
	return;
}



char* lookupcode (char* text)
{	int i=0;
	long int val;
	char *pstring;
	strlwr(text);			//convert search to lower case
	static char code[20]="xx ";	//assume no match
	int found=0;	//assume no match

	while (strlen(table[i])>3)
	{    if(!strcmp(text,&table[i][3]))
			{	found=i;break;}
		i++;
	};

	if (found)
		{	strcpy(code,&table[i][0]); //copy setup string to code
			strupr(code);
		}
	else strcpy(code,"xx ");
	return code;
}


int process_line(char* line,int linenum)
{    char position,*code;
	int input,shift_flag=0;
	char newtext[255];
	char gooddigit[11]="0123456789";
	char whitespace[9]=" \t:=";
	char goodhex[17]="0123456789abcdef";

	strlwr(line);
	if (verbose) cout << "\nPROCESSING LINE "<< linenum << "\n" << line;

	//check for null or comment line
	if (!strlen(line)) return 0; //null line
	if (0==strcspn(line,whitespace)) return 0; //comment line

	//check for board selection (MK40 is default)
	if (!strncmp(line,"mk40",4))
		{	if (verbose) cout <<"\n40 Inputs selected" << linenum;
			num_of_inputs=40; return 0;
		}

	if (!strncmp(line,"mk64",4))
		{	if (verbose) cout <<"\n64 Inputs selected" << linenum;
			num_of_inputs=64; return 0;
		}

	if (!strncmp(line,"mk",2))
		{	cout <<"\nBoard select must be MK40 or MK64" << linenum
			; return 1;
		}


	//check for valid command
	if (!strncmp(line,"sh",2))	//'shift' line start with "sh"
	{	shift_flag++;}

 // check for new opcodes v2.00
	else if (!strncmp(line,"fastest",7))	//'skip' flag line start with "skip"
	{	Gfast=3; return 0;}
	else if (!strncmp(line,"faster",6))	//'skip' flag line start with "skip"
	{	Gfast=2; return 0;}
	else if (!strncmp(line,"fast",4))	//'skip' flag line start with "skip"
	{	Gfast=1; return 0;}
	else if (!strncmp(line,"skip",4))	//'skip' flag line start with "skip"
	{	Gskip=1; return 0;}
	else if (!strncmp(line,"noswap",6))	//'noswap' flag line start with "noswap"
	{	Gnoswap=1; return 0;}
	else if (!strncmp(line,"type",4))	//'typematic' flag line start with "type"
	{	position=strcspn(line,whitespace);
		if (position==strlen(line))
		{	cout <<"\nvalue for typematic was not found" << linenum
			; return 1;
		}
		Gtypematic=-1;
		if (line[position+2]=='n') Gtypematic=1;	//on
		if (line[position+2]=='f') Gtypematic=0;	//off
//		if (line[position+2]=='e') Gtypematic=255;	//keep
		if (Gtypematic<0)
			{cout << "\nInvaild setting in line "<< linenum;
			return 1;}
		cout << "typematic set to " << Gtypematic;
		return 0;
	}
	else if (!strncmp(line,"bank",4))	//'bank' flag line start with "bank"
	{	position=strcspn(line,whitespace);
		if (position==strlen(line))
		{	cout <<"\nvalue for bank was not found" << linenum
			; return 1;
		}
		Gbank=-1;
		if (line[position+1]=='0') Gbank=0;	//0
		if (line[position+1]=='1') Gbank=1;	//1
		if (line[position+1]=='2') Gbank=2;	//2
		if (Gbank<0)
			{cout << "\nInvaild bank number in line "<< linenum;
			return 1;}
		cout << "program bank " << Gbank;
		return 0;
	}
 // end v.200 command checking

	else if (strncmp(line,"in",2))	//else line must start as "in"
		{	cout <<"\nbad command in line " << linenum; return 1;
		}
	position=strcspn(line,gooddigit);
	if (position==strlen(line))
		{	cout <<"\ninput number was not found in line " << linenum
			; return 1;
		}
	if (position>7)
		{	cout <<"\ninput number must start with in the first seven chars" << linenum
			; return 1;
		}

	if (!strchr(gooddigit,line[position+1]))
		{	cout <<"\ninput number must two digits in line " << linenum
			; return 1;
		}
	input=(line[position]-0x30)*10+line[position+1]-0x30;
	if (input<0||input>95) //=num_of_inputs)
		{	cout <<"\ninput number must be 0-"<<num_of_inputs-1
			<<" in line "<<linenum;
			return 1;
		}
//shift inputs must be 0 to 7
	if (shift_flag&&(input<0||input>7))
		{	cout <<"\nshifted input number must be 0-7"
			<<" in line "<<linenum;
			return 1;
		}
	if (!strchr(whitespace,line[position+2]))
		{	cout <<"\nWhite space must follow input number in line "
			<< linenum; return 1;
		}
	char* subtext;
	subtext=line;
	position+=3;			//move position past input digits
	subtext+=position;		//point to key definition
	if (!strlen(subtext))
		{	cout <<"\nNo key was assigned in line " << linenum
			; return 1;
		}
	position=strcspn(subtext,whitespace); //find end of key def
	if (position==0) position++;		   //if key def IS whitespace
	strncpy(newtext,subtext,position);		//get key definition
	newtext[position]=0;				//add terminator

	code=lookupcode(newtext);	//code string is stored elsewhere

//9-24-00 added special key, direct hex codes
	if (newtext[0]=='$')
	{	if (!strchr(goodhex,newtext[1]))
		{	cout <<"\nInvalid key assignment in line " << linenum
			; return 1;
		};
		if (!strchr(goodhex,newtext[2]))
		{	cout <<"\nInvalid key assignment in line " << linenum
			; return 1;
		};
		code[0]=newtext[1]; //hex code high
		code[1]=newtext[2]; //hex code low
						//keep space
		code[3]=newtext[0]; //$
		code[4]=newtext[1]; //hex text high
		code[5]=newtext[2]; //hex text low
		code[6]=0x0;		//terminator
	};
//end of special keys

//offset input number in array if its shifted
	if (shift_flag) input+=64;
//save data in buffer
	strcpy(databuffer[input],code); //save in permanent buffer
	if (code[0]=='x')
		{	cout <<"\ninvalid key assignment in line " << linenum
			<< "\n" << newtext;
			return 1;
		}
	strncpy(databuffer[input],code,2);	//save data in buffer
	if (verbose)
		{	cout << "\nINPUT " << input << " WILL BE SET TO " << code;}

	return 0;
}

void print_results(int inputs)
{	clrscr();
	cout << "INPUT CODE NAME";
	gotoxy(27,1);
	cout << "INPUT CODE NAME";
	gotoxy(53,1);
	cout << "INPUT CODE NAME";
	gotoxy(75,1);
	cout<<revision;


	int i,j,k;
	switch (inputs)
	{

	case 64:

	for(i=0,j=22,k=44;i<22;i++,j++,k++)
		{    gotoxy(2,i+2);
			if (i<10) cout << '0';
			cout << i << "   "<< databuffer[i][0] << databuffer[i][1];
			cout << "   " << (char*) databuffer[i]+3 << (char) 13;
			gotoxy(29,i+2);
			if (j<inputs) {
				cout << j << "   "<< databuffer[j][0] << databuffer[j][1];
				cout << "   " << (char*) databuffer[j]+3 << "\n";}
			gotoxy(55,i+2);
			if  (k<inputs) {
				cout << k << "   "<< databuffer[k][0] << databuffer[k][1];
				cout << "   " << (char*) databuffer[k]+3 << "\n";}
		}
	break;

	case 40:
	for(i=0,j=20,k=64;i<20;i++,j++,k++)
		{    gotoxy(2,i+2);
			if (i<10) cout << '0';
			cout << i << "   "<< databuffer[i][0] << databuffer[i][1];
			cout << "   " << (char*) databuffer[i]+3 << (char) 13;
			gotoxy(29,i+2);
			if (j<inputs) {
				cout << j << "   "<< databuffer[j][0] << databuffer[j][1];
				cout << "   " << (char*) databuffer[j]+3 << "\n";}
			gotoxy(55,i+2);
			if  (k<72) {
				cout << "S" << k-64 << "   "<< databuffer[k][0] << databuffer[k][1];
				cout << "   " << (char*) databuffer[k]+3 << "\n";}
		}
	break;

	case 8:
	gotoxy(1,1);
	cout << " INPUT NAME   CODE  NAME                                           ";
	cout << "\n-----------------------------------------------";
	for(i=0,j=64;i<8;i++,j++)
		{    gotoxy(2,i+3);
			if (i<10) cout << "SHIFT KEY ";
			cout << i << "   "<< databuffer[j][0] << databuffer[j][1];
			cout << "   " << (char*) databuffer[j]+3 << (char) 13;
		}

	}
	return;
}

void setdelay(char* pvalue);
void setdelay(char* pvalue)
{    int i,number;

	number=pvalue[0]*10+pvalue[1]-480-48;
	if ((number<0)||(number>89)) number=0;

	Wait_more4ready=4;

	for(i=0;i<number;i++) Wait_more4ready+=Wait_more4ready/4;
	return;
}


int main(int argc,char* argv[]);
int main(int argc,char* argv[])
{	int error=0;
	int i,j,linenum=0,shift_only=0;
	char cval;
	char datalow;
	char datahigh;

	cout<<"\nKEYMAP program revision "<<revision;

	for (i=0;i<96;i++)	//12-27-00
		{    for(j=0;j<3;j++) {databuffer[i][j]=0;}
		};
	char line[160];

	//check command line for filename of script
	if (argc<2) {	cout<<"\nUseage error - proper syntax is MAPKEYS <FILENAME>";
				return 1; //abort program
			  }
	//check for and set IO parameters from command line
	set_io_parameters(argc,argv);

//main loop that reads and handles arguments passes to program
	for (i=1;i<argc;i++)
	{	if (argv[i][0]=='-')
		{    if((0x20|argv[i][1])=='s') //set switch inputs only
			    shift_only++;
			if((0x20|argv[i][1])=='e') //set don't disable comout
			    No_disable++;
			if((0x20|argv[i][1])=='f') //set fixed wait on wait4ready sub
			    setdelay(&argv[i][2]);
		}
		else
		{
			//open file and process it
			//	ifstream inpfile("\\tc\\script.asm");

			cout << "\nOpening script file - " << argv[i];	//12-27-00
			ifstream inpfile(argv[i]);	//open file
			if (inpfile.bad()) 	//check for exists
			{	cout << "\nFile error - Program aborted"; return 1;
			}
			linenum=1;	//start counting lines
			Gfast=0;		//assume normal eeprom responses
			Gbank=-1;      //assume no bank selecting
			Gskip=0;       //assume not to skip undefined inputs
			Gnoswap=0;     //assume to normally swap upper input addresses
			Gtypematic=-1; //asumme to leave typematic alone
			while(inpfile&&!inpfile.eof())
			{    inpfile.getline(line,150);
				error=process_line(line,linenum++);
				if (error)
					{cout <<"\nScript File Error - Press any key"
					; getch(); return 1;}
			}
		}//end else
	}//end for
//check that at least one script file ran
	if (!linenum)
		{	cout<<"\nUseage error - proper syntax is KEYMAP <FILENAME>";
			return 1; //abort program
		}
	//print results of processing

	i=num_of_inputs;
	if (shift_only) i=8;  //let 'print results' know
					  //that only shifts get programmed.

	if ((!quiet)&&(!verbose)){ print_results(i);	gotoxy(1,23);}

	if(quiet) cout<< "\nFile(s) processed...Sending to MK";

	//write the EEPROM now.

	while(kbhit()) getch();

	error=0;
	if( (No_disable==0) || (Gfast==3) )
		{    error=comout_disable();	//disable comout!!!
			if (error) {cout << "\nCommunication Failure - press any key"
					;getch(); return 1;}
		}

	if (Gfast==1) write_ram(16,64+16);  //no responses, no comout
	if (Gfast==2) write_ram(16,64+16);  //no responses, no comout
	if (Gfast==3) write_ram(16,64);  //no responses

//v2.00 bank selection
	if ((Gbank>-1)&&(Gbank<3))
	  {	write_port(165+Gbank);
		if(!quiet) cout << "\n";
		if(!verbose) gotoxy(50,24);
		if(!quiet) cout << " Bank "<< Gbank<< " Selected ";
	  }


//Get the number of inputs
//	if((!num_of_inputs)&&(!error)) error=getMKrevision();

//Get a copy of the current EEPROM, it will save time spent later.
//	if(!error) error=getEEPROM();

//program the normal keys if required.
	if (!shift_only)
	   {		for (i=0;i<num_of_inputs;i++)
			{    error=write_eeprom((char)i,&databuffer[i][0]);
				if (error) break;
			}
	   }
//Force shift mode select to on or off only (default = off)
//	databuffer[64][0]='0';
//	if (databuffer[64][1]!='1') databuffer[64][1]='0';

//MK40 program the shifted keys
	if ((num_of_inputs==40)&&(!error))
	   {		for(i=64;i<72;i++)
			{    j=i-24;		//move 64 buffer to 40 EEPROM
				if(j&1) j--;   //compensate the byte swapping
				else j++;
				if (Gnoswap) j=i-24; //no need to compensate
				error=write_eeprom((char)j,&databuffer[i][0]);
				if (error) break;
			}
	   }

//MK64 program the shifted keys
	if ((num_of_inputs==64)&&(!error))
	   {		for(i=65;i<72;i++)
			{//this really writes to ram
			 error=write_eeprom((char)i,&databuffer[i][0]);
			 //buffer 65 to 71 goes to RAM 59 to 65
			}
	   }


//Set shift flag in RAM for both MK40 & MK64
	if(!error)
	{	if (verbose) cout <<"\nSetting RAM copy of Shift Status";
		if (databuffer[64][1]=='1') write_ram(17,1);
		else write_ram(17,0);
	}


//Set HIGH RAM for addr 64 and 72 to 95
	if((Gbank)&&(num_of_inputs==64)&&(!error))
	{
		write_eeprom(64,&databuffer[64][0]);
	}

	if((Gbank==2)&&(num_of_inputs==64)&&(!error))
	{	for(i=72;i<96;i++)
		write_eeprom((char)i,&databuffer[i][0]);
	}


//Set typematic flag in RAM for both MK40 & MK64
	if((!error)&&(Gtypematic>=0))
	{	if (verbose) cout <<"\nSetting typematic flag in RAM";
		write_ram(24,4-4*Gtypematic);
	}


	if( (No_disable==0) || (Gfast==3) )
		{    	if (comout_enable()) error=1;
		}

//	if (Gfast) write_ram(16,0);  //why do it?


	if (verbose) cout<<"\nKEYMAP program revision "<<revision;
	if (verbose) cout<<"\nMKIO program revision "<<IOrevision;
	if (verbose) cout<<"\nACK time limit is "<<ack_time_limit<<"0 mS";
	if (verbose) cout<<"\nGfast is "<<Gfast;


	if (error) {cout << "\nERROR DETECTED - press any key"
					;getch(); return 1;}

	return 0;
}

int write_eeprom(char address,char* data)
{
	//const TRUE=1,FALSE=0;
	const char null=0x0,lower=0x20;
	char in,real_address;

	int i,time_limit=40; //wait upto 1.00 seconds for response

//pull data from ascii string
	char datalow=data[1]|0x20;	//get low nybble in lower ascii
	char datahigh=data[0]|0x20;   //get high nybble in lower ascii
	datalow-=0x30;datahigh-=0x30;	//shift ascii '0' to real 00h
	if (datalow>0x0a) datalow-=0x27;	//if it was alpha then shift further
	if (datahigh>0x0a) datahigh-=0x27;	//if it was alpha then shift further

//v2.00 skip undefined inputs option
	if ((Gskip==1)&&(strlen(data)<2))
		{if(!quiet){	if (!verbose) gotoxy(1,23);
					cout << "\nSkipping EEPROM Location "
					<< (int) address << "          ";
				 }
		 return 0;
		}
//v2.00 end skip undefined inputs option

	if (strlen(data)<2) {datalow=0;datahigh=0;};	//its a blank null


//compensate for wiring error for inputs 40 through 63
	real_address=address;
	if ((Gnoswap==0)&&(address>39)&&(address<64))
		{if (address&1) real_address--;
			 else real_address++;};

//if(EEPROM[real_address]==datalow+16*datahigh)
  //	{	if(!quiet) cout <<"No need";
    //		return 0;
	//}

	if ((address>64)&&(address<72))
	{	if (verbose) cout <<"\nWriting shift key 0"<< address-64<<" in RAM";
		write_ram((char)address-6,datahigh*16+datalow);
		return 0;
	}

	if (address==64)
	{    if (Gbank<0) return 0; //can't write high ram
		if (verbose) cout <<"\nSetting HIGH RAM copy of Shift Status";
		write_high_ram((char)address-32+8*Gbank,datahigh*16+datalow);
		return 0;
	}

	if (address>71)
	{    if (Gbank!=2) return 0; //there is no extended ram
		if (verbose) cout <<"\nWriting extended address "<<(int) address <<" in HIGH RAM";
		write_high_ram((char)address-16,datahigh*16+datalow);
		return 0;
	}

	if(!quiet){	if (!verbose) gotoxy(1,23);
				cout << "\nWriting EEPROM Location "
					<< (int) address << " , ";
			}

	for(i=0;i<3;i++)
	{	while (kbhit()) {getch();};	//clear key buffer

		write_port(0xae);		//AE (EEPROM WRITE)

		write_port(real_address);//(EEPROM address)

		write_port(datahigh);	//(EEPROM datahigh)

		write_port(datalow);	//(EEPROM datalow)

		if(Gfast==1) wait(2);
		if(Gfast) return 0;

		in=getkey(time_limit);
		if ((in==null)&&(verbose)) cout<<"Timeout Error1 ";
		if (((in|lower)=='f')&&(verbose)) cout<<"Failed  ";
		if ((in|lower)=='p') {if (!quiet) cout<<"Passed  ";
						  return 0;};

		wait(2);
	} //end for
	if(quiet) cout<<"\nEprom programming ";
	cout<<"Failed";
	return 1;
}
