// Input Test Program V2.00 1/28/2002
// NOTE: line numbers are hardware ordered until just before they
//	    are put on screen.

#include "string.h"
#include "iostream.h"
#include "conio.h"
#include "dos.h"
#include "mk_io200.cpp"

char revision[8]="V2.00";

int ascii2dec(int text);
int getbyte();
void show(int address,int count,int color);
void show_lower_pin(int x, int y,int color,char text[15]);
void show_upper_pin(int x, int y,int color,char text[15]);
void	show_ledgend();
void show_dummy();
void show_input(int line,int color);
int get_static();
void eight_bit(int bits,int number);

int get_static()
{    int time_limit=50,number=0;
	int bits,key,error=0;
	write_port(0xa4);	//request a joy buffer dump
	do	{	key=getkey(time_limit);
			if (key<1) {error++;break;}
		}
	while ( (key|0x20) !='z');

	do	{	key=getkey(time_limit);
			if (key<1) {error++;break;}
			if ( (key|0x20) == 'z') break;
			bits=16*ascii2dec(key);
			//get lower nybble
			key=getkey(time_limit);
			if (key<1) {error++;break;}
			if ( (key|0x20) == 'z') break;
			bits+=ascii2dec(key);
			eight_bit(bits,number);
			number+=8;
		}
	while (1);
	if (error) return -1;
	return number;
}

void eight_bit(int bits,int number)
{         number+=7;
	for(int i=0;i<8;i++)
	{	if (bits&1)	{ show_input(number,YELLOW);}
		else			{ show_input(number,LIGHTCYAN);}
		bits=bits/2;
		number--;
	}
}



void	show_ledgend()
{    textcolor(WHITE);
	gotoxy(1,1);
	cprintf("Input Test V2.00..press 'Esc' to exit");
	gotoxy(1,2);
	cprintf("Do not press any other keyboard keys!");

	gotoxy(43,2);
	textcolor(LIGHTGREEN);
	cprintf("GREEN=Pressed");
	gotoxy(43,1);
	textcolor(LIGHTRED);
	cprintf("RED=Released");
	gotoxy(59,2);
	textcolor(LIGHTCYAN);
	cprintf("CYAN=Stuck Down");
	gotoxy(59,1);
	textcolor(YELLOW);
	cprintf("YELLOW=Never Pressed");
}


void show_dummy()
{	show_upper_pin(50,11,7,"GND|O");
	show_upper_pin(2,11,7,"GND|O");
	show_upper_pin(4,11,7,"NUM|O");
	show_lower_pin(2,13,7,"O|GND");
	show_lower_pin(4,13,7,"O|CAPS");
	show_lower_pin(6,13,7,"O|SCROLL");
}


void show_input(int line,int color)
{	int upper=0,x,y;
	char tens,ones;
	char utext[15]="INxx|O";
	char ltext[15]="O|INxx";


	if ((line>63)||(line<0)) return;
	if (!(line&1)) upper++;	//Even "hardware" inputs are on top

// Correct MK64 wiring quirk
	if (line>39)
		{	if (line&1) line--;
			else line++;
		}

	tens=line/10+48;
	ones=line%10+48;
	utext[2]=tens;ltext[4]=tens;
	utext[3]=ones;ltext[5]=ones;

	y=13-2*upper;
	x=((line+1)&254)+6;
	if (line>34) x+=4;	//skip 4 pin gap
	if (line>39) x=(line&254)+16; //MK64 inputs

	if (upper)  show_upper_pin(x,y,color,utext);
	if (!upper) show_lower_pin(x,y,color,ltext);
}


void show_lower_pin(int x, int y,int color,char text[15])
{    //x+=1;y+=1;		//offset
	char single[2]="x";
	textcolor(color);
	for(int i=0;i<strlen(text);i++)
	{	gotoxy(x,y);
//		cout <<text[i];
		single[0]=text[i];
		cprintf(&single[0]);
		y++;
	};
	return;
}
void show_upper_pin(int x, int y,int color,char text[15])
{    //x+=1;y+=1;		//offset
	char single[2]="x";
	textcolor(color);
	for(int i=strlen(text);i>0;i--)
	{	gotoxy(x,y);
//		cout <<text[i-1];
		single[0]=text[i-1];
		cprintf(&single[0]);
		y--;
	};
	return;
}

int main(int argc,char* argv[]);
int main(int argc,char* argv[])
{    textcolor(LIGHTGRAY);

	set_io_parameters(argc,argv);
	if (verbose) cout<<"\nINTEST program revision "<<revision;
	if (verbose) cout<<"\nMKIO program revision "<<IOrevision;
	if (verbose) cout<<"\nACK time limit is "<<ack_time_limit<<"0 mS";

	const char com_stat=16,joy_stat=15,shift_stat=17;
	int i,error=0,byte,released,num_of_inputs,old_byte;
	int old_shift,time_limit=50;	//500mS


//Prepare hardware for input test
	error=comout_disable();
	if (error) {cout<<"\nFatal Error";return 1;}

//Disply stagnant part of screen
	clrscr();
	show_ledgend();
	show_dummy();

	num_of_inputs=get_static();
	if ( (num_of_inputs!=40) && (num_of_inputs!=64) )
		{	gotoxy(1,24);cout << "Initialization ERROR:"
			<< num_of_inputs;return 1;
		}



	write_verify_ram(joy_stat,24,time_limit,24); //force disable eeprom lookup
	old_shift=read_ram(shift_stat,time_limit);
	if (old_shift<0) {cout << "MK Read Error"; return 1;}
	write_verify_ram(shift_stat,0,time_limit,1); //force disable shift function
	write_verify_ram(com_stat,16,time_limit); //force mk into acsii hex mode



//Update input presses and releases until ESC is pressed
	error=0,released=0,byte=0;
	do{  old_byte=byte;
		byte=getbyte();
		if (byte<0) {error++;break;}
		if ((byte>127)&(byte<208)) released=2;
		show_input(127&(byte-1),10+released);
		released=0;

	  }
	while((old_byte!=240)||(byte!=118));	//escape key
	gotoxy(1,23);
	if (error) cout << "Input error occured";

//Restore hardware to normal operation
	gotoxy(1,23);
	cout << "Restoring Normal operation";

	wait(3);
	while (kbhit()) {getch();};	//clear key buffer

//	verbose=1;
//	IOverbose=1;

	error=comout_disable();


	error+=write_verify_ram(shift_stat,old_shift&1,time_limit,1);

	error+=write_verify_ram(joy_stat,0,time_limit,24);

	error+=comout_enable();

	if (error) cout << "\nNot Restored!";
	else cout << "\nComplete.";

	if (verbose) cout<<"\nREADID program revision "<<revision;
	if (verbose) cout<<"\nMKIO program revision "<<IOrevision;
	if (verbose) cout<<"\nACK time limit is "<<ack_time_limit<<"0 mS";

	return 0;
}



int getbyte()
{	int i,inh,inl;
	inh=getch();inh=inh|32; //first ascii char
	inl=getkey(50);  //wait up to 0.5 for second ascii char
	if (inl<1) return -1;	//timeout
	return 16*ascii2dec(inh)+ascii2dec(inl);
}

int ascii2dec(int text)
{	text=text|32;	//convert to lower case
	text-=48;	//convert '0-9' to 0-9
	if (text>9) text-=39;	//convert 'a-f' to 10-15
	return text;
}
