// MK40 & MK64 EEPROM BANK CHANGE


#include "iostream.h"
#include "dos.h"
#include "conio.h"
#include "MK_IO200.cpp"

char revision[8]="V2.00";

void error_message();

int main(int argc,char* argv[]);
int main(int argc,char* argv[])
{

	int cval,i;

	if (argc<2) {	error_message();
				return 16; //abort program
			  }

	set_io_parameters(argc,argv);
	if (verbose) cout<<"\nBANK program revision "<<revision;
	if (verbose) cout<<"\nMKIO program revision "<<IOrevision;
	if (verbose) cout<<"\nACK time limit is "<<ack_time_limit<<"0 mS";




	for (i=1;i<argc;i++)
		{	cval=argv[i][0];
			if (cval!='-') break;
		}

	if (cval!='-')
		{    if((cval>47)&(cval<58)) cval-=48;

			switch (cval)
			{
			 case 0:
			 case 1:
			 case 2:
				if(!quiet) cout <<"\nSetting EEPROM BANK to "<<cval;
				write_port(165+cval);
				break;
			 case 'd':
			 case 'D':
				cout << "\nDumping Keymap in Hex\n";
				write_port(162);
				break;
			 case 'a':
			 case 'A':
				cout <<"\nActive bank is "<<read_ram(219,50);
				break;
			 default:
				error_message();
				return 16; //abort program
			}

			return 0;
		}

	error_message();
	return 16;
}

void error_message()
{	cout<<"\nSyntax error - EEPROM BANK NOT CHANGED";
	cout<< "\nBANK 0   SET DEFAULT SAVED (POWER ON) KEYMAP\n"
	<< "BANK 1   SET ALTERNATE SAVED KEYMAP\n"
	<< "BANK 2   SET TEMPORARY KEYMAP (NOT SAVED WITH POWER OFF)\n"
	<< "BANK A   DISPLAY ACTIVE BANK NUMBER\n"
	<< "BANK D   DUMP KEYMAP IN HEX\n";
	return;
}

