// MK40 & MK64 AUX OUTPUT V2.00


#include "iostream.h"
#include "dos.h"
#include "conio.h"
#include "MK_IO200.cpp"

char revision[8]="V2.00";

void error_message();

int main(int argc,char* argv[]);
int main(int argc,char* argv[])
{

	int cval,i;

	if (argc<2) {	error_message();
				return 16; //abort program
			  }

	set_io_parameters(argc,argv);
	if (verbose) cout<<"\nAUXOUT program revision "<<revision;
	if (verbose) cout<<"\nMKIO program revision "<<IOrevision;
	if (verbose) cout<<"\nACK time limit is "<<ack_time_limit<<"0 mS";




	for (i=1;i<argc;i++)
		{	cval=argv[i][0];
			if (cval!='-') break;
		}

	if (cval!='-')
		{    cval-=48;
			if ((cval<0)||(cval>3))
			  {	error_message();
				return 16; //abort program
			  }

			if(!quiet) cout <<"\nSetting AUX output to "<<cval;
			write_ram(5,cval*8+4);  //write to portb on PIC
			return 0;
		}

	error_message();
	return 16;
}

void error_message()
{	cout<<"\nSyntax error - AUX output not set";
	cout<< "\nAUXOUT 0  for AUX1 low  & AUX2 low\n"
	<< "AUXOUT 1  for AUX1 high & AUX2 low\n"
	<< "AUXOUT 2  for AUX1 low  & AUX2 HI-Z\n"
	<< "AUXOUT 3  for AUX1 high & AUX2 HI-Z\n\n"
	<< "The pin closest to AUX label is AUX1.\n"
	<< "The middle pin is ground.\n"
	<< "and the last pin is AUX2 (open drain output).\n";
	return;
}

